/*
 * Copyright (c) 1999-2001 Lutris Technologies, Inc. All Rights
 * Reserved.
 * 
 * This source code file is distributed by Lutris Technologies, Inc. for
 * use only by licensed users of product(s) that include this source
 * file. Use of this source file or the software that uses it is covered
 * by the terms and conditions of the Lutris Enhydra Development License
 * Agreement included with this product.
 * 
 * This Software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
 * ANY KIND, either express or implied. See the License for the specific terms
 * governing rights and limitations under the License.
 * 
 * Contributor(s):
 * 
 * $Id: LegacyEvent.java,v 1.1.1.1 2001/01/05 05:11:17 sese0235 Exp $
 */

package de.kxml.parser;

/**
 * Class for ProcessingInstructions and Comments
 */
public class LegacyEvent extends ParseEvent {
    int    type;
    String text;

    /**
     * creates a new LegacyEvent with the given type and string content
     */
    public LegacyEvent(int type, String text) {
	this.type = type;
	this.text = text;
    }

    /**
     * returns the type of the sgml-legacy event,
     * PROCESSING_INSTRUCTION, ENTITY_DECLARATION, or COMMENT
     */
    public int getType() {
	return type;
    } 

    /**
     * returns always false.
     */
    public boolean endCheck(StartTag start) {
	return false;
    } 

    /**
     * returns the string content of the legacy event
     */
    public String getText() {
	return text;
    } 

}

